import os
import torch
import json
from Model.pipeline_muse import PipelineMuse, PipelineMuseInpainting
from Model.modeling_transformer import MaskGitTransformer, MaskGiTUViT
from Model.modeling_transformer_v2 import MaskGiTUViT_v2
import HPSv2.hpsv2 as hpsv2
import pandas as pd
import numpy as np
from PIL import Image

pipe = PipelineMuse(
    vae="ckpt/vqgan",
    transformer="ckpt/generator"
)

image_path = 'results'
text_path = "prompts.txt"
with open(text_path, 'r', encoding='gbk') as file:
    lines = file.readlines()
    for line in lines:
        prompt = line.strip()
        output_image = pipe(text=prompt, generator=torch.Generator('cuda').manual_seed(2))[0]
        save_path = os.path.join(image_path, f"{prompt}.jpg")
        output_image.save(save_path) 

